// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Idstack.pas' rev: 10.00

#ifndef IdstackHPP
#define IdstackHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Idexception.hpp>	// Pascal unit
#include <Idstackconsts.hpp>	// Pascal unit
#include <Idobjs.hpp>	// Pascal unit
#include <Idglobal.hpp>	// Pascal unit
#include <Idsys.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Idstack
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EIdSocketError;
class PASCALIMPLEMENTATION EIdSocketError : public Idexception::EIdException 
{
	typedef Idexception::EIdException inherited;
	
private:
	int FLastError;
	
public:
	__fastcall virtual EIdSocketError(const int AErr, const AnsiString AMsg);
	__property int LastError = {read=FLastError, nodefault};
public:
	#pragma option push -w-inl
	/* EIdException.Create */ inline __fastcall virtual EIdSocketError(AnsiString AMsg)/* overload */ : Idexception::EIdException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdSocketError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Idexception::EIdException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdSocketError(int Ident)/* overload */ : Idexception::EIdException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdSocketError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Idexception::EIdException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdSocketError(const AnsiString Msg, int AHelpContext) : Idexception::EIdException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdSocketError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Idexception::EIdException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdSocketError(int Ident, int AHelpContext)/* overload */ : Idexception::EIdException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdSocketError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Idexception::EIdException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdSocketError(void) { }
	#pragma option pop
	
};


class DELPHICLASS TIdPacketInfo;
class PASCALIMPLEMENTATION TIdPacketInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	AnsiString FSourceIP;
	int FSourcePort;
	AnsiString FDestIP;
	int FDestPort;
	unsigned FSourceIF;
	unsigned FDestIF;
	Byte FTTL;
	
public:
	__property Byte TTL = {read=FTTL, write=FTTL, nodefault};
	__property AnsiString SourceIP = {read=FSourceIP, write=FSourceIP};
	__property int SourcePort = {read=FSourcePort, write=FSourcePort, nodefault};
	__property unsigned SourceIF = {read=FSourceIF, write=FSourceIF, nodefault};
	__property AnsiString DestIP = {read=FDestIP, write=FDestIP};
	__property int DestPort = {read=FDestPort, write=FDestPort, nodefault};
	__property unsigned DestIF = {read=FDestIF, write=FDestIF, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TIdPacketInfo(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TIdPacketInfo(void) { }
	#pragma option pop
	
};


typedef TMetaClass* TIdSocketListClass;

class DELPHICLASS TIdSocketList;
class PASCALIMPLEMENTATION TIdSocketList : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int operator[](int AIndex) { return Items[AIndex]; }
	
protected:
	Idglobal::TIdCriticalSection* FLock;
	virtual int __fastcall GetItem(int AIndex) = 0 ;
	
public:
	__fastcall virtual TIdSocketList(void);
	__fastcall virtual ~TIdSocketList(void);
	virtual void __fastcall Add(int AHandle) = 0 ;
	virtual TIdSocketList* __fastcall Clone(void) = 0 ;
	virtual int __fastcall Count(void) = 0 ;
	/*         class method */ static TIdSocketList* __fastcall CreateSocketList(TMetaClass* vmt);
	__property int Items[int AIndex] = {read=GetItem/*, default*/};
	virtual void __fastcall Remove(int AHandle) = 0 ;
	virtual void __fastcall Clear(void) = 0 ;
	virtual bool __fastcall Contains(int AHandle) = 0 ;
	void __fastcall Lock(void);
	#pragma option push -w-inl
	/* virtual class method */ virtual bool __fastcall Select(TIdSocketList* AReadList, TIdSocketList* AWriteList, TIdSocketList* AExceptList, const int ATimeout = 0xfffffffe) { return Select(__classid(TIdSocketList), AReadList, AWriteList, AExceptList, ATimeout); }
	#pragma option pop
	/*         class method */ static bool __fastcall Select(TMetaClass* vmt, TIdSocketList* AReadList, TIdSocketList* AWriteList, TIdSocketList* AExceptList, const int ATimeout = 0xfffffffe);
	virtual bool __fastcall SelectRead(const int ATimeout = 0xfffffffe) = 0 ;
	virtual bool __fastcall SelectReadList(TIdSocketList* &VSocketList, const int ATimeout = 0xfffffffe) = 0 ;
	void __fastcall Unlock(void);
};


class DELPHICLASS TIdStack;
class PASCALIMPLEMENTATION TIdStack : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	AnsiString FHostName;
	AnsiString FLocalAddress;
	Classes::TStrings* FLocalAddresses;
	virtual AnsiString __fastcall HostByName(const AnsiString AHostName, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	AnsiString __fastcall MakeCanonicalIPv6Address(const AnsiString AAddr);
	virtual AnsiString __fastcall ReadHostName(void) = 0 ;
	virtual void __fastcall PopulateLocalAddresses(void) = 0 ;
	virtual AnsiString __fastcall GetLocalAddress(void) = 0 ;
	virtual Classes::TStrings* __fastcall GetLocalAddresses(void) = 0 ;
	
public:
	virtual int __fastcall Accept(int ASocket, AnsiString &VIP, int &VPort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall Bind(int ASocket, const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall Connect(const int ASocket, const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	__fastcall virtual TIdStack(void);
	virtual void __fastcall Disconnect(int ASocket) = 0 ;
	virtual int __fastcall IOControl(const int s, const unsigned cmd, unsigned &arg) = 0 ;
	/*         class method */ static void __fastcall Make(TMetaClass* vmt);
	/*         class method */ static void __fastcall IncUsage(TMetaClass* vmt);
	/*         class method */ static void __fastcall DecUsage(TMetaClass* vmt);
	virtual void __fastcall GetPeerName(int ASocket, AnsiString &VIP, int &VPort) = 0 ;
	virtual void __fastcall GetSocketName(int ASocket, AnsiString &VIP, int &VPort) = 0 ;
	virtual AnsiString __fastcall HostByAddress(const AnsiString AAddress, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual Word __fastcall HostToNetwork(Word AValue) = 0 /* overload */;
	virtual unsigned __fastcall HostToNetwork(unsigned AValue) = 0 /* overload */;
	virtual __int64 __fastcall HostToNetwork(__int64 AValue) = 0 /* overload */;
	virtual Word __fastcall HostToNetwork(Word * AValue)/* overload */;
	bool __fastcall IsIP(AnsiString AIP);
	virtual void __fastcall Listen(int ASocket, int ABackLog) = 0 ;
	virtual int __fastcall NewSocketHandle(const int ASocketType, const int AProtocol, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0), const bool AOverlapped = false) = 0 ;
	virtual Word __fastcall NetworkToHost(Word AValue) = 0 /* overload */;
	virtual unsigned __fastcall NetworkToHost(unsigned AValue) = 0 /* overload */;
	virtual __int64 __fastcall NetworkToHost(__int64 AValue) = 0 /* overload */;
	virtual Word __fastcall NetworkToHost(Word * AValue)/* overload */;
	virtual void __fastcall GetSocketOption(int ASocket, int ALevel, int AOptName, /* out */ int &AOptVal) = 0 ;
	virtual void __fastcall SetSocketOption(int ASocket, int ALevel, int AOptName, int AOptVal) = 0 /* overload */;
	AnsiString __fastcall ResolveHost(const AnsiString AHost, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0));
	virtual int __fastcall Receive(int ASocket, Idglobal::TBytes &VBuffer) = 0 ;
	virtual int __fastcall Send(int ASocket, const Idglobal::TBytes ABuffer, int AOffset = 0x0, int ASize = 0xffffffff) = 0 ;
	virtual int __fastcall ReceiveFrom(int ASocket, Idglobal::TBytes &VBuffer, AnsiString &VIP, int &VPort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual int __fastcall SendTo(int ASocket, const Idglobal::TBytes ABuffer, const int AOffset, const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual unsigned __fastcall ReceiveMsg(int ASocket, Idglobal::TBytes &VBuffer, TIdPacketInfo* APkt, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual bool __fastcall SupportsIPv6(void) = 0 ;
	bool __fastcall IsValidIPv4MulticastGroup(const AnsiString Value);
	bool __fastcall IsValidIPv6MulticastGroup(const AnsiString Value);
	virtual void __fastcall SetMulticastTTL(int AHandle, const Byte AValue, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall SetLoopBack(int AHandle, const bool AValue, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall DropMulticastMembership(int AHandle, const AnsiString AGroupIP, const AnsiString ALocalIP, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual void __fastcall AddMulticastMembership(int AHandle, const AnsiString AGroupIP, const AnsiString ALocalIP, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	virtual Word __fastcall CalcCheckSum(const Idglobal::TBytes AData);
	virtual void __fastcall WriteChecksum(int s, Idglobal::TBytes &VBuffer, const int AOffset, const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0)) = 0 ;
	__property AnsiString HostName = {read=FHostName};
	__property AnsiString LocalAddress = {read=GetLocalAddress};
	__property Classes::TStrings* LocalAddresses = {read=GetLocalAddresses};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TIdStack(void) { }
	#pragma option pop
	
};


typedef TMetaClass* TIdStackClass;

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TIdStack* GStack;
extern PACKAGE TMetaClass* GSocketListClass;
extern PACKAGE void __fastcall SetStackClass(TMetaClass* AStackClass);
extern PACKAGE TIdStack* __fastcall IdStackFactory(void);

}	/* namespace Idstack */
using namespace Idstack;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Idstack
